define(['angular', 'app', 'localResourceDirectoryService'], function (angular, app) {
	"use strict";
	app.service('NotificationsService', function ($parse, CollectionCRUDService, localResourceDirectoryService, NotificationsPreferencesService, pageService, formatter) {

		var NotificationsService = function() {
			var config = {}

			config.dependency = {
				service : localResourceDirectoryService,
				linkTitles : {
					GET : "notifications",
					POST : "notification",
					PUT: "notification"
				}
			};

			config.collection = {
				objectType : "Notifications",
				name: "notifications",
				filter: function (list, filters) {
					if(!filters.status || filters.status.toLowerCase() === "all") {
						return list;
					}

					var readStatus = filters.status.toLowerCase() === "read";

					return list.filter(function (item) {
						return item.readFlag === readStatus;
					});
				}
			};

			config.object = {
				uidKey : "id",
				requestTransform : function(item) {
					item.createDate = formatter.getFormattedBackendDate(item.createDate);
					return item;
				},
				responseTransform : function(item) {
					var partialBodyArray = item.body.split(" ");

					item.partialBody = "";

					for(var i = 0; i < partialBodyArray.length && (item.partialBody.length + partialBodyArray[i].length <= 50); i++) {
						item.partialBody += " " + partialBodyArray[i];
					}

					if(!item.partialBody) {
						item.partialBody = item.body.substr(0, 50);
					}

					item.createDateOnly = formatter.getFormattedFrontendDate(item.createDate);
					item.createTime = formatter.getFormattedFrontendTime(item.createDate);
					item.createDate = item.createDateOnly + " " + item.createTime;
					item.dateSortKey = new Date(item.createDate);
					
					return item;
				}
			};

			CollectionCRUDService.call(this, config);

			var sort = function (list) {
				return list.sort(function (left, right) {
					var leftDate = new Date(left.dateSortKey).getTime(),
						rightDate = new Date(right.dateSortKey).getTime();
					if(leftDate !== rightDate) {
						return leftDate > rightDate ? -1 : 1;
					}
				});
			};

			var fetchRequestTransformDates = function (queryParams) {
				var start = formatter.getFormattedBackendDate(queryParams.startDate) || "",
					end = formatter.getFormattedBackendDate(queryParams.endDate) || "";

				queryParams.startDate = start;
				queryParams.endDate = end;
				return queryParams;
			};

			this.fetch = function (queryParams) {
				var that = this,
					localQueryParams,
					isOptedIn = NotificationsPreferencesService.dataPointers.notificationPreference.optInSelected;

				localQueryParams = fetchRequestTransformDates(angular.copy(queryParams));
				localQueryParams.type = (!isOptedIn && localQueryParams.type.indexOf(',') > -1) ? 'FIT_HEART' : localQueryParams.type;

				var requestPromise = that._onRequestComplete(that.BaseCRUDService.fetch(localQueryParams));				
				requestPromise.then(function (response) {
					that.dataPointers.filters = angular.copy(queryParams);
					that.dataPointers.list = sort(response, that.config.collection.sortComparator);
					that.dataPointers.link = response.link;
					if (angular.isDefined(response.unfilteredCount)) {
						that.dataPointers.unfilteredItemCount = response.unfilteredCount;
					}
				});
				return requestPromise;
			};
		};

		NotificationsService.prototype = Object.create(CollectionCRUDService.prototype);
		NotificationsService.prototype.constructor = NotificationsService;

		return NotificationsService;
	});
});